<?php
/*
Plugin Name: Disable Comments Control
Description: Полностью отключает комментарии на сайте + кнопки для массового включения/отключения комментариев у всех записей. Добавлена настройка блокировки wp-comments-post.php.
Version: 1.7
Author: revtail.ru
Author URI: https://revtail.ru
*/

if (!defined('ABSPATH')) {
    exit;
}

if (!function_exists('custom_plugin_update_info_wtn')) {
	function custom_plugin_update_info_wtn($transient) {
		if (empty($transient->checked)) {
			return $transient;
		}

		// Уникальный slug плагина
		$plugin_slug = 'disable-comments-control';

		// Запрос к серверу обновлений
		$response = wp_remote_get("https://revtail.ru/wordpress-update-plugins/update-server.php?plugin=$plugin_slug");

		if (is_wp_error($response)) {
			return $transient;
		}

		$data = json_decode(wp_remote_retrieve_body($response));
		if (!$data || isset($data->error)) {
			return $transient;
		}

		// Текущая версия
		$current_version = '1.7';

		// Добавляем обновление, если оно доступно
		if (version_compare($current_version, $data->new_version, '<')) {
			$transient->response = array_merge($transient->response ?? [], [
				"$plugin_slug/$plugin_slug.php" => (object) [
					'slug'        => $plugin_slug,
					'new_version' => $data->new_version,
					'package'     => $data->package,
					'url'         => $data->url,
				]
			]);
		}

		return $transient;
	}
}

// Подключаем к системе обновлений WordPress
add_filter('site_transient_update_plugins', 'custom_plugin_update_info_wtn', 10, 1);

if (!function_exists('custom_plugin_update_details')) {
	function custom_plugin_update_details($false, $action, $args) {
		if ($action !== 'plugin_information' || $args->slug !== 'disable-comments-control') {
			return $false;
		}

		$response = wp_remote_get("https://revtail.ru/wordpress-update-plugins/update-server.php?plugin=$plugin_slug");
		
		if (is_wp_error($response)) {
			return $false;
		}

		$data = json_decode(wp_remote_retrieve_body($response));

		if (!$data) {
			return $false;
		}

		return (object) [
			'name'           => 'Disable Comments Control',
			'slug'           => 'disable-comments-control',
			'version'        => $data->new_version,
			'author'         => 'revtail',
			'homepage'       => 'https://revtail.ru/',
			'download_link'  => $data->package,
			//'tested'         => '6.5', // Версия WP, с которой протестировано
			//'requires'       => '5.0', // Минимальная версия WP
			'sections'       => [
				'description'  => 'Описание вашего плагина.',
				'changelog'    => 'Список изменений в новой версии.',
			],
		];
	}
}

// Добавляем хук для вывода информации об обновлении
add_filter('plugins_api', 'custom_plugin_update_details', 10, 3);

// === Полное отключение комментариев на сайте ===
add_action('admin_init', function () {
    foreach (get_post_types() as $post_type) {
        add_filter('comments_open', '__return_false', 20, 2);
        add_filter('pings_open', '__return_false', 20, 2);
    }
});
//add_filter('comments_array', '__return_empty_array', 10, 2);

// Блокировка wp-comments-post.php (по настройке)
add_action('init', function () {
    if (get_option('dcc_block_comments_post_php', 'yes') === 'yes') {
        if (basename($_SERVER['PHP_SELF']) === 'wp-comments-post.php') {
            wp_die('Комментирование отключено на этом сайте.', 'Ошибка', array('response' => 403));
        }
    }
});

// === Админка: Страница управления комментариями ===
add_action('admin_menu', function () {
    add_menu_page(
        'Отключение комментариев',
        'Отключение комментариев',
        'manage_options',
        'disable-comments-control',
        'dcc_render_admin_page',
        'dashicons-admin-comments',
        81
    );
});

// === Интерфейс страницы ===
function dcc_render_admin_page() {
    $block_enabled = get_option('dcc_block_comments_post_php', 'yes');
    ?>
    <div class="wrap">
        <h1>Отключение комментариев</h1>
        <form method="post">
            <?php wp_nonce_field('dcc_bulk_action', 'dcc_nonce'); ?>
            <p>
                <input type="submit" name="dcc_disable_comments" class="button button-secondary" value="Отключить комментарии у всех записей" />
                <input type="submit" name="dcc_enable_comments" class="button button-primary" value="Включить комментарии у всех записей" />
            </p>
            <h2>Блокировка wp-comments-post.php</h2>
            <p>
                <label>
                    <input type="radio" name="dcc_block_comments_post_php" value="yes" <?php checked($block_enabled, 'yes'); ?>>
                    Включить блокировку
                </label><br>
                <label>
                    <input type="radio" name="dcc_block_comments_post_php" value="no" <?php checked($block_enabled, 'no'); ?>>
                    Отключить блокировку
                </label>
            </p>
            <p>
                <input type="submit" name="dcc_save_block_setting" class="button" value="Сохранить настройки" />
            </p>
        </form>
    </div>
    <?php
}

// === Обработка кнопок и настроек ===
add_action('admin_init', function () {
    if (!current_user_can('manage_options')) return;
    if (!isset($_POST['dcc_nonce']) || !wp_verify_nonce($_POST['dcc_nonce'], 'dcc_bulk_action')) return;

    $post_types = get_post_types(array('public' => true), 'names');

    if (isset($_POST['dcc_disable_comments'])) {
        dcc_set_comments_status($post_types, 'closed');
        add_action('admin_notices', function () {
            echo '<div class="notice notice-success is-dismissible"><p>Комментарии отключены у всех записей.</p></div>';
        });
    }

    if (isset($_POST['dcc_enable_comments'])) {
        dcc_set_comments_status($post_types, 'open');
        add_action('admin_notices', function () {
            echo '<div class="notice notice-success is-dismissible"><p>Комментарии включены у всех записей.</p></div>';
        });
    }

    if (isset($_POST['dcc_save_block_setting']) && isset($_POST['dcc_block_comments_post_php'])) {
        $value = $_POST['dcc_block_comments_post_php'] === 'yes' ? 'yes' : 'no';
        update_option('dcc_block_comments_post_php', $value);
        add_action('admin_notices', function () {
            echo '<div class="notice notice-success is-dismissible"><p>Настройка блокировки wp-comments-post.php сохранена.</p></div>';
        });
    }
});

// === Массовое включение/отключение комментариев ===
function dcc_set_comments_status($post_types, $status) {
    global $wpdb;
    $post_types_in = implode("','", array_map('esc_sql', $post_types));
    $wpdb->query("UPDATE {$wpdb->posts} SET comment_status = '{$status}' WHERE post_type IN ('{$post_types_in}')");
}