<?php
/**
 * Plugin Name:          WooCommerce время доставки
 * Description:          Позвольте вашим клиентам выбрать желаемую дату и время доставки при оформлении заказа в WooCommerce
 * Version:              1.3
 * Author:               revtail.ru
 * Author URI:           https://revtail.ru/
 */

// Если этот файл вызывается напрямую, прекращаем выполнение.
if ( ! defined( 'WPINC' ) ) {
	wp_die();
}

/**
 * Текущая версия плагина.
 */
define( 'DTWC_VERSION', '1.3' );

if (!function_exists('custom_plugin_update_info_dtwc')) {
	function custom_plugin_update_info_dtwc($transient) {
		if (empty($transient->checked)) {
			return $transient;
		}

		// Уникальный slug плагина
		$plugin_slug = 'delivery-times-wc';

		// Запрос к серверу обновлений
		$response = wp_remote_get("https://revtail.ru/wordpress-update-plugins/update-server.php?plugin=$plugin_slug");

		if (is_wp_error($response)) {
			return $transient;
		}

		$data = json_decode(wp_remote_retrieve_body($response));
		if (!$data || isset($data->error)) {
			return $transient;
		}

		// Текущая версия
		$current_version = '1.3';

		// Добавляем обновление, если оно доступно
		if (version_compare($current_version, $data->new_version, '<')) {
			$transient->response = array_merge($transient->response ?? [], [
				"$plugin_slug/$plugin_slug.php" => (object) [
					'slug'        => $plugin_slug,
					'new_version' => $data->new_version,
					'package'     => $data->package,
					'url'         => $data->url,
				]
			]);
		}

		return $transient;
	}
}

// Подключаем к системе обновлений WordPress
add_filter('site_transient_update_plugins', 'custom_plugin_update_info_dtwc', 20, 1);

if (!function_exists('custom_plugin_update_details')) {
	function custom_plugin_update_details($false, $action, $args) {
		if ($action !== 'plugin_information' || $args->slug !== 'delivery-times-wc') {
			return $false;
		}

		$response = wp_remote_get("https://revtail.ru/wordpress-update-plugins/update-server.php?plugin=$plugin_slug");
		
		if (is_wp_error($response)) {
			return $false;
		}

		$data = json_decode(wp_remote_retrieve_body($response));

		if (!$data) {
			return $false;
		}

		return (object) [
			'name'           => 'Время доставки для WooCommerce',
			'slug'           => 'delivery-times-wc',
			'version'        => $data->new_version,
			'author'         => 'revtail',
			'homepage'       => 'https://revtail.ru/',
			'download_link'  => $data->package,
			//'tested'         => '6.5', // Версия WP, с которой протестировано
			//'requires'       => '5.0', // Минимальная версия WP
			'sections'       => [
				'description'  => 'Описание вашего плагина.',
				'changelog'    => 'Список изменений в новой версии.',
			],
		];
	}
}

// Добавляем хук для вывода информации об обновлении
add_filter('plugins_api', 'custom_plugin_update_details', 10, 3);

/**
 * Код, который выполняется при активации плагина.
 * Этот процесс описан в includes/class-dtwc-activator.php
 */
function activate_dtwc() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-dtwc-activator.php';
	Delivery_Times_For_WooCommerce_Activator::activate();
}

/**
 * Код, который выполняется при деактивации плагина.
 * Этот процесс описан в includes/class-dtwc-deactivator.php
 */
function deactivate_dtwc() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-dtwc-deactivator.php';
	Delivery_Times_For_WooCommerce_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_dtwc' );
register_deactivation_hook( __FILE__, 'deactivate_dtwc' );

/**
 * Основной класс плагина, который используется для определения интернационализации,
 * хуков для админки и публичных страниц.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-dtwc.php';

/**
 * Запуск плагина.
 *
 * Поскольку все внутри плагина зарегистрировано через хуки,
 * запуск плагина с этого момента не влияет на жизненный цикл страницы.
 *
 */
function run_dtwc() {

	$plugin = new DTWC();
	$plugin->run();

}
run_dtwc();

/**
 * Добавить ссылку настроек на странице плагинов
 *
 * @param array $links массив ссылок, связанных с плагином.
 * @return array обновленный массив ссылок, связанных с плагином.
 */
function dtwc_settings_link( $links ) {
	$settings_link = '<a href="admin.php?page=dtwc_settings">' . esc_attr__( 'Настройки', 'delivery-times-wc' ) . '</a>';
	array_unshift( $links, $settings_link );
	return $links;
}

$pluginname = plugin_basename( __FILE__ );

add_filter( "plugin_action_links_$pluginname", 'dtwc_settings_link' );

/**
 * Добавить проверку для нашего плагина перед редиректом
 */
function dtwc_activate() {
  add_option( 'dtwc_do_activation_redirect', true );
}
register_activation_hook( __FILE__, 'dtwc_activate' );

/*Редирект на страницу настроек плагина "Время доставки для WooCommerce" после активации*/
function dtwc_redirect() {
	if ( get_option( 'dtwc_do_activation_redirect', false ) ) {
			delete_option( 'dtwc_do_activation_redirect' );
			if ( null === filter_input( INPUT_POST, 'activate-multi' ) ) {
					wp_safe_redirect( 'admin.php?page=dtwc_settings' );
			}
	}
}
add_action( 'admin_init', 'dtwc_redirect' );

// Название директории и название основного файла плагина Woocommerce
$required_plugin = 'woocommerce/woocommerce.php';

// Проверяем активность плагина
if ( is_plugin_active($required_plugin) ) {
    // Если плагин установлен и активирован, продолжаем выполнение нашего плагина
    add_action('plugins_loaded', 'my_plugin_init');
    
    function my_plugin_init() {
        // Логика активации вашего плагина
        echo "Ваш плагин успешно активировался!";
    }
} else {
    // Сообщение об ошибке при отсутствии активного плагина
    deactivate_plugins(plugin_basename(__FILE__)); // Деактивируем свой плагин
    wp_die("Ошибка: ваш плагин требует активной версии плагина Woocommerce.");
}