<?php

/*Добавление времени доставки в данные заказа в админке*/
function dtwc_woocommerce_admin_order_data_after_address( $order ) {
    // ID заказа.
    $order_id = $order->get_id();

    // Получаем дату доставки.
    $delivery_date_meta = get_post_meta( $order_id, 'dtwc_delivery_date', true );

    // Форматируем дату доставки в читаемом виде.
    $delivery_date = date( apply_filters( 'dtwc_date_format', get_option( 'date_format' ) ), strtotime( $delivery_date_meta ) );

    // Получаем время доставки.
    $delivery_time_meta = get_post_meta( $order_id, 'dtwc_delivery_time', true );

    // Форматируем время доставки в читаемом виде.
    $delivery_time = date( apply_filters( 'dtwc_time_format', get_option( 'time_format' ) ), strtotime( $delivery_time_meta ) );

    // Отображаем детали доставки.
    if ( '' != $delivery_date_meta ) {
        // Получаем информацию о курьере.
        $delivery_details = '<p class="dtwc-delivery-date"><strong>' . dtwc_delivery_date_label() . ':</strong><br />' . $delivery_date . ' @ ' . $delivery_time . '</p>';

        echo apply_filters( 'dtwc_admin_order_received_delivery_details', $delivery_details );
    }
}

/*Выполнение специфичных действий при инициализации WooCommerce*/
function dtwc_woocommerce_init() {
    // Настройка отображения для редактирования заказа.
    $after_address = dtwc_delivery_time_edit_order_display();

    // Размещение отображения на экране редактирования заказа.
    if ( 'billing' == $after_address ) {
        add_action( 'woocommerce_admin_order_data_after_billing_address', 'dtwc_woocommerce_admin_order_data_after_address', 10, 1 );
    } else {
        add_action( 'woocommerce_admin_order_data_after_shipping_address', 'dtwc_woocommerce_admin_order_data_after_address', 10, 1 );
    }

    // Настройка отображения на странице оформления заказа.
    $checkout_display = dtwc_delivery_time_checkout_display();

    // Отображать после данных для выставления счета.
    if ( 'after_billing' == $checkout_display ) {
        add_action( 'woocommerce_after_checkout_billing_form', 'dtwc_delivery_info_checkout_fields' , 10, 1 );
    }
    // Отображать после данных для доставки.
    if ( 'after_shipping' == $checkout_display ) {
        add_action( 'woocommerce_after_checkout_shipping_form', 'dtwc_delivery_info_checkout_fields' , 10, 1 );
    }
    // Отображать после комментариев к заказу.
    if ( 'after_notes' == $checkout_display ) {
        add_action( 'woocommerce_after_order_notes', 'dtwc_delivery_info_checkout_fields' , 10, 1 );
    }
}
add_action( 'woocommerce_init', 'dtwc_woocommerce_init' );