<?php

/*Добавление полей даты и времени доставки на страницу оформления заказа*/
function dtwc_delivery_info_checkout_fields( $checkout ) {

    // Устанавливаем переменные.
    $open_time  = strtotime( dtwc_business_opening_time() );
    $close_time = strtotime( dtwc_business_closing_time() );

    // Создаем время доставки.
    $delivery_time = $open_time;

    // Округляем до ближайших 30 минут (30 * 60 секунд).
    $delivery_time = ceil( $delivery_time / ( 30 * 60 ) ) * ( 30 * 60 );

    // Создаем массив с вариантами времени, включая дефолтный.
    $times = array( '' => apply_filters( 'dtwc_checkout_delivery_times_select_default_text', __( 'Выберите желаемое время для доставки', 'delivery-times-wc' ) ) );

    // Прокручиваем и добавляем время доставки, исходя из времени открытия и закрытия.
    while( $delivery_time <= $close_time && $delivery_time >= $open_time ) {

        // Время на подготовку доставки.
        $delivery_prep = dtwc_delivery_prep_time();

        // Устанавливаем время на подготовку для strtotime.
        if ( '1' == $delivery_prep ) {
            $strtotime = '+' . $delivery_prep . 'minute';
        } elseif ( $delivery_prep > 1 ) {
            $strtotime = '+' . $delivery_prep . 'minutes';
        } else {
            $strtotime = 'now';
        }

        // Добавляем время доставки в массив с вариантами.
        $times[date( 'H:i', $delivery_time )] = date( apply_filters( 'dtwc_time_format', get_option( 'time_format' ) ), $delivery_time );

        // Обновляем переменную времени доставки.
        $delivery_time = strtotime( '+30 minutes', $delivery_time );
    }

    // Устанавливаем дефолтное значение.
    $require_date = FALSE;

    // Требуется ли выбрать дату?
    if ( 'on' == dtwc_require_delivery_date() ) {
        $require_date = TRUE;
    }

    // Создаем поле для даты доставки.
    woocommerce_form_field( 'dtwc_delivery_date', array(
        'type'     => 'text',
        'class'    => array( 'dtwc_delivery_date form-row-wide' ),
        'label'    => dtwc_delivery_date_label(),
        'required' => $require_date,
    ), $checkout->get_value( 'dtwc_delivery_date' ) );

    // Устанавливаем дефолтное значение.
    $require_time = FALSE;

    // Требуется ли выбрать время?
    if ( 'on' == dtwc_require_delivery_time() ) {
        $require_time = TRUE;
    }

    // Создаем поле для времени доставки.
    woocommerce_form_field( 'dtwc_delivery_time', array(
        'type'     => 'select',
        'class'    => array( 'dtwc_delivery_time form-row-wide' ),
        'label'    => dtwc_delivery_time_label(),
        'required' => $require_time,
        'options'  => $times
    ), $checkout->get_value( 'dtwc_delivery_time' ) );

}

/*Обработка полей даты и времени доставки при оформлении заказа*/
function dtwc_delivery_date_checkout_field_process() {

    // Создаем сообщение об ошибке для даты.
    $message = esc_attr__( 'Пожалуйста, выберите дату доставки.', 'delivery-times-wc' );

    // Проверяем, если дата не выбрана, добавляем ошибку.
    if ( ! filter_input( INPUT_POST, 'dtwc_delivery_date' ) && 'on' == dtwc_require_delivery_date() ) {
        wc_add_notice( apply_filters( 'dtwc_delivery_date_error_notice', $message ), 'error' );
    }

    // Создаем сообщение об ошибке для времени.
    $message = esc_attr__( 'Пожалуйста, выберите время доставки.', 'delivery-times-wc' );

    // Проверяем, если время не выбрано, добавляем ошибку.
    if ( ! filter_input( INPUT_POST, 'dtwc_delivery_time' ) && 'on' == dtwc_require_delivery_time() ) {
        wc_add_notice( apply_filters( 'dtwc_delivery_time_error_notice', $message ), 'error' );
    }
}
add_action( 'woocommerce_checkout_process', 'dtwc_delivery_date_checkout_field_process' );

/*Сохранение даты и времени доставки в заказе*/
function dtwc_add_order_delivery_info_to_order ( $order_id ) {
	if ( null !== filter_input( INPUT_POST, 'dtwc_delivery_date' ) && '' != filter_input( INPUT_POST, 'dtwc_delivery_date' ) ) {
		add_post_meta( $order_id, 'dtwc_delivery_date',  sanitize_text_field( filter_input( INPUT_POST, 'dtwc_delivery_date' ) ) );
	}
	if ( null !== filter_input( INPUT_POST, 'dtwc_delivery_time' ) && '' != filter_input( INPUT_POST, 'dtwc_delivery_time' ) ) {
		add_post_meta( $order_id, 'dtwc_delivery_time',  sanitize_text_field( filter_input( INPUT_POST, 'dtwc_delivery_time' ) ) );
	}
}
add_action( 'woocommerce_checkout_update_order_meta', 'dtwc_add_order_delivery_info_to_order' , 10, 1 );

/*Добавление информации о дате и времени доставки в письма WooCommerce*/
function dtwc_add_delivery_info_to_emails( $fields, $sent_to_admin, $order ) {
    // Получаем ID заказа.
    if ( version_compare( get_option( 'woocommerce_version' ), '3.0.0', ">=" ) ) {
        $order_id = $order->get_id();
    } else {
        $order_id = $order->id;
    }

    // Удаляем время доставки из писем, если требуется.
    $remove = dtwc_remove_delivery_time_from_emails();

    // Если нужно, сразу возвращаем поля без времени доставки.
    if ( 'on' == $remove ) {     
        return $fields;
    }

    // Получаем дату доставки.
    $delivery_date_meta = get_post_meta( $order_id, 'dtwc_delivery_date', true );

    // Форматируем дату доставки.
    $delivery_date = date( apply_filters( 'dtwc_date_format', get_option( 'date_format' ) ), strtotime( $delivery_date_meta ) );

    // Отображаем дату доставки.
    if ( '' != $delivery_date_meta ) {
        $fields[ dtwc_delivery_date_label() ] = array(
            'label' => dtwc_delivery_date_label(),
            'value' => $delivery_date,
        );
    }

    // Получаем время доставки.
    $delivery_time_meta = get_post_meta( $order_id, 'dtwc_delivery_time', true );

    // Форматируем время доставки.
    $delivery_time = date( apply_filters( 'dtwc_time_format', get_option( 'time_format' ) ), strtotime( $delivery_time_meta ) );

    // Отображаем время доставки.
    if ( '' != $delivery_time_meta ) {
        $fields[ dtwc_delivery_time_label() ] = array(
            'label' => dtwc_delivery_time_label(),
            'value' => $delivery_time,
        );
    }

    return $fields;
}
add_filter( 'woocommerce_email_order_meta_fields', 'dtwc_add_delivery_info_to_emails' , 10, 3 );

/*Добавление информации о дате и времени доставки на страницу "Спасибо за заказ"*/
function dtwc_add_delivery_info_to_order_received_page( $order ) {
    // Получаем ID заказа.
	if ( version_compare( get_option( 'woocommerce_version' ), '3.0.0', ">=" ) ) {
        $order_id = $order->get_id();
    } else {
        $order_id = $order->id;
    }

    // Получаем дату доставки.
    $delivery_date_meta = get_post_meta( $order_id, 'dtwc_delivery_date', true );

    // Форматируем дату доставки.
    $delivery_date = date( apply_filters( 'dtwc_date_format', get_option( 'date_format' ) ), strtotime( $delivery_date_meta ) );

    // Получаем время доставки.
    $delivery_time_meta = get_post_meta( $order_id, 'dtwc_delivery_time', true );

    // Форматируем время доставки.
    $delivery_time = date( apply_filters( 'dtwc_time_format', get_option( 'time_format' ) ), strtotime( $delivery_time_meta ) );

    // Отображаем детали доставки.
    if ( '' != $delivery_date_meta ) {
        echo do_action( 'dtwc_order_received_delivery_details_before' );

        // Отображаем информацию о доставке.
        $delivery_details = '<p class="dtwc-delivery-date"><strong>' . dtwc_delivery_date_label() . ':</strong> ' . $delivery_date . ' @ ' . $delivery_time . '</p>';

        echo apply_filters( 'dtwc_order_received_delivery_details', $delivery_details );

        echo do_action( 'dtwc_order_received_delivery_details_after' );
	}
}
add_action( 'woocommerce_order_details_after_order_table_items', 'dtwc_add_delivery_info_to_order_received_page', 10 , 1 );