<?php

// Выход, если доступ через прямой запрос.
if ( ! defined( 'ABSPATH' ) ) {
	wp_die();
}

/**
 * Получить формат времени доставки, выбранный в настройках DTWC админки
 *
 * @return string|bool
 */
function dtwc_business_delivery_time_format() {
    $business = get_option( 'dtwc_business' );
    // По умолчанию - false.
    $time_format = FALSE;

    if ( isset( $business['delivery_time_format'] ) && '' !== $business['delivery_time_format'] ) {
        $time_format = $business['delivery_time_format'];
    }

	return apply_filters( 'dtwc_business_delivery_time_format', $time_format );
}

/**
 * Получить дни доставки, выбранные в настройках DTWC админки
 *
 * @return string|bool
 */
function dtwc_business_delivery_days() {
    $business = get_option( 'dtwc_business' );
    // По умолчанию - false.
    $delivery_days = FALSE;

    if ( isset( $business['delivery_days'] ) && '' !== $business['delivery_days'] ) {
        $delivery_days = $business['delivery_days'];
    }

	return apply_filters( 'dtwc_business_delivery_days', $delivery_days );
}

/**
 * Получить время открытия, выбранное в настройках DTWC админки
 *
 * @return string
 */
function dtwc_business_opening_time() {
    $business = get_option( 'dtwc_business' );
    // По умолчанию - false.
    $opening_time = FALSE;

    if ( isset( $business['opening_time'] ) && '' !== $business['opening_time'] ) {
        $opening_time = $business['opening_time'];
    }

	return apply_filters( 'dtwc_business_opening_time', $opening_time );
}

/**
 * Получить время закрытия, выбранное в настройках DTWC админки
 *
 * @return string|bool
 */
function dtwc_business_closing_time() {
    $business = get_option( 'dtwc_business' );
    // По умолчанию - false.
    $closing_time = FALSE;

    if ( isset( $business['closing_time'] ) && '' !== $business['closing_time'] ) {
        $closing_time = $business['closing_time'];
    }

	return apply_filters( 'dtwc_business_closing_time', $closing_time );
}

/**
 * Получить метку для даты доставки, добавленную в настройках DTWC админки
 *
 * @return string|bool
 */
function dtwc_delivery_date_label() {
    $basic = get_option( 'dtwc_basic' );

    // По умолчанию метка даты доставки.
    $date_label = esc_attr__( 'Дата доставки', 'delivery-times-wc' );

    if ( isset( $basic['delivery_date_label'] ) && '' !== $basic['delivery_date_label'] ) {
        $date_label = $basic['delivery_date_label'];
    }

	return apply_filters( 'dtwc_delivery_date_label', $date_label );
}

/**
 * Получить настройку обязательности даты доставки, добавленную в настройки DTWC админки
 *
 * @return string|bool
 */
function dtwc_require_delivery_date() {
    $basic = get_option( 'dtwc_basic' );

    // Отключение обязательности даты доставки.
    $require_date = 'off';

    if ( isset( $basic['require_delivery_date'] ) && '' !== $basic['require_delivery_date'] ) {
        $require_date = $basic['require_delivery_date'];
    }

	return apply_filters( 'dtwc_require_delivery_date', $require_date );
}

/**
 * Получить метку для времени доставки, добавленную в настройки DTWC админки
 *
 * @return string|bool
 */
function dtwc_delivery_time_label() {
    $basic = get_option( 'dtwc_basic' );

    // По умолчанию метка времени доставки.
    $time_label = esc_attr__( 'Время доставки', 'delivery-times-wc' );

    if ( isset( $basic['delivery_time_label'] ) && '' !== $basic['delivery_time_label'] ) {
        $time_label = $basic['delivery_time_label'];
    }

	return apply_filters( 'dtwc_delivery_time_label', $time_label );
}

/**
 * Получить настройку обязательности времени доставки, добавленную в настройки DTWC админки
 *
 * @return string|bool
 */
function dtwc_require_delivery_time() {
    $basic = get_option( 'dtwc_basic' );

    // Отключение обязательности времени доставки.
    $require_time = 'off';

    if ( isset( $basic['require_delivery_time'] ) && '' !== $basic['require_delivery_time'] ) {
        $require_time = $basic['require_delivery_time'];
    }

	return apply_filters( 'dtwc_require_delivery_time', $require_time );
}

/**
 * Получить количество дней на подготовку, добавленное в настройки DTWC админки
 *
 * @return string|bool
 */
function dtwc_delivery_prep_days() {
    $basic = get_option( 'dtwc_basic' );

    // Дни подготовки (по умолчанию).
    $prep_days = 0;

    if ( isset( $basic['prep_days'] ) && '' !== $basic['prep_days'] ) {
        $prep_days = $basic['prep_days'];
    }

	return apply_filters( 'dtwc_delivery_prep_days', $prep_days );
}

/**
 * Получить время на подготовку, добавленное в настройки DTWC админки
 *
 * @return string|bool
 */
function dtwc_delivery_prep_time() {
    $basic = get_option( 'dtwc_basic' );

    // Время на подготовку (по умолчанию).
    $prep_time = NULL;

    if ( isset( $basic['prep_time'] ) && '' !== $basic['prep_time'] ) {
        $prep_time = $basic['prep_time'];
    }

	return apply_filters( 'dtwc_delivery_prep_time', $prep_time );
}

/**
 * Получить количество дней для предварительного заказа, добавленное в настройки DTWC админки
 *
 * @return string|bool
 */
function dtwc_delivery_preorder_days() {
    $basic = get_option( 'dtwc_basic' );

    // Дни предварительного заказа (по умолчанию).
    $preorder_days = NULL;

    if ( isset( $basic['preorder_days'] ) && '' !== $basic['preorder_days'] ) {
        $preorder_days = $basic['preorder_days'];
    }

	return apply_filters( 'dtwc_delivery_preorder_days', $preorder_days );
}

/**
 * Получить расположение времени доставки на экране редактирования заказов
 *
 * @return string|bool
 */
function dtwc_delivery_time_edit_order_display() {
    $advanced = get_option( 'dtwc_advanced' );

    // Отключить отображение (по умолчанию).
    $display = FALSE;

    if ( isset( $advanced['delivery_time_edit_order_display'] ) && '' !== $advanced['delivery_time_edit_order_display'] ) {
        $display = $advanced['delivery_time_edit_order_display'];
    }

	return apply_filters( 'dtwc_delivery_time_edit_order_display', $display );
}

/**
 * Получить расположение времени доставки на экране оформления заказа
 *
 * @return string|bool
 */
function dtwc_delivery_time_checkout_display() {
    $advanced = get_option( 'dtwc_advanced' );

    // Отображение (по умолчанию).
    $display = 'after_billing';

    if ( isset( $advanced['delivery_time_checkout_display'] ) && '' !== $advanced['delivery_time_checkout_display'] ) {
        $display = $advanced['delivery_time_checkout_display'];
    }

	return apply_filters( 'dtwc_delivery_time_checkout_display', $display );
}

/**
 * Получить настройку удаления времени доставки из писем, добавленную в настройки DTWC админки
 *
 * @return string|bool
 */
function dtwc_remove_delivery_time_from_emails() {
    $advanced = get_option( 'dtwc_advanced' );

    // Отключение времени доставки в письмах.
    $remove = 'off';

    if ( isset( $advanced['remove_delivery_time_from_emails'] ) && '' !== $advanced['remove_delivery_time_from_emails'] ) {
        $remove = $advanced['remove_delivery_time_from_emails'];
    }

	return apply_filters( 'dtwc_remove_delivery_time_from_emails', $remove );
}