<?php

// Выход, если доступ через прямой запрос.
if ( ! defined( 'ABSPATH' ) ) {
	wp_die();
}

/**
 * Водители доставки для WooCommerce
 *
 * Добавляет детали даты доставки в таблицу деталей заказа на панели водителя
 * ниже даты заказа.
 */
function dtwc_driver_dashboard_order_details_table_tbody_bottom() {
    // ID заказа.
    $order_id = filter_input( INPUT_GET, 'orderid' );

    // Получаем дату доставки.
    $delivery_date_meta = get_post_meta( $order_id, 'dtwc_delivery_date', true );

    // Преобразуем дату доставки в читаемый формат.
    $delivery_date = date( apply_filters( 'dtwc_date_format', get_option( 'date_format' ) ), strtotime( $delivery_date_meta ) );

    // Получаем время доставки.
    $delivery_time_meta = get_post_meta( $order_id, 'dtwc_delivery_time', true );

    // Преобразуем время доставки в читаемый формат.
    $delivery_time = date( apply_filters( 'dtwc_time_format', get_option( 'time_format' ) ), strtotime( $delivery_time_meta ) );

    // Отображаем детали доставки.
    if ( '' != $delivery_date_meta ) {
        // Получаем детали водителя доставки.
        $delivery_times = '<tr><td class="dtwc-delivery-date">' . dtwc_delivery_date_label() . '</td><td>' . $delivery_date . ' - ' . $delivery_time . '</td></tr>';

        echo apply_filters( 'dtwc_driver_dashboard_order_details_table_tbody_bottom', $delivery_times );
    }
}
add_action( 'ddwc_driver_dashboard_order_details_table_tbody_bottom', 'dtwc_driver_dashboard_order_details_table_tbody_bottom' );