<?php
// Выход, если доступ через прямой запрос.
if ( ! defined( 'ABSPATH' ) ) {
	wp_die();
}

/*Определение глобальных констант*/
// Версия плагина.
if ( ! defined( 'DTWC_ADMIN_VERSION' ) ) {
	define( 'DTWC_ADMIN_VERSION', '1.2' );
}
if ( ! defined( 'DTWC_ADMIN_NAME' ) ) {
	define( 'DTWC_ADMIN_NAME', trim( dirname( plugin_basename( __FILE__ ) ), '/' ) );
}
if ( ! defined( 'DTWC_ADMIN_DIR' ) ) {
	define( 'DTWC_ADMIN_DIR', WP_PLUGIN_DIR . '/' . DTWC_ADMIN_NAME );
}
if ( ! defined( 'DTWC_ADMIN_URL' ) ) {
	define( 'DTWC_ADMIN_URL', WP_PLUGIN_URL . '/' . DTWC_ADMIN_NAME );
}

/**
 * Инициализация WP-OOP-Settings-API
 *
 * Инициализирует WP-OOP-Settings-API.
 */

/*Класс `WP_OOP_Settings_API`*/
require_once DTWC_ADMIN_DIR . '/class-dtwc-admin-settings.php';

/**
 * Действия/Фильтры
 *
 * Относятся ко всем настройкам API
 */
if ( class_exists( 'DeliveryTimesForWooCommerceAdminSettings' ) ) {

	/**
	 * Загружает настройки администратора при инициализации
	 * 
	 * @return void
	 */
	function dtwc_load_admin_settings() {
		/**
		 * Создание объекта.
		 *
		 * Объект для класса `DeliveryTimesForWooCommerceAdminSettings`.
		 */
		$dtwc_obj = new DeliveryTimesForWooCommerceAdminSettings();

		// Раздел: Основные настройки.
		$dtwc_obj->add_section(
			array(
				'id'    => 'dtwc_basic',
				'title' => esc_attr__( 'Основные настройки', 'delivery-times-wc' ),
			)
		);

		// Раздел: Рабочие часы.
		$dtwc_obj->add_section(
			array(
				'id'    => 'dtwc_business',
				'title' => esc_attr__( 'Рабочие часы', 'delivery-times-wc' ),
			)
		);

		// Раздел: Расширенные настройки.
		$dtwc_obj->add_section(
			array(
				'id'    => 'dtwc_advanced',
				'title' => esc_attr__( 'Расширенные настройки', 'delivery-times-wc' ),
			)
		);

		// Поле: Метка для даты доставки.
		$dtwc_obj->add_field(
			'dtwc_basic',
			array(
				'id'      => 'delivery_date_label',
				'type'    => 'text',
				'name'    => esc_attr__( 'Метка для даты доставки', 'delivery-times-wc' ),
				'desc'    => esc_attr__( 'Метка, отображаемая на странице оформления заказа и в деталях заказа', 'delivery-times-wc' ),
				'default' => esc_attr__( 'Дата доставки', 'delivery-times-wc' ),
			)
		);

		// Поле: Обязательность выбора даты доставки.
		$dtwc_obj->add_field(
			'dtwc_basic',
			array(
				'id'   => 'require_delivery_date',
				'type' => 'checkbox',
				'name' => esc_attr__( 'Обязательность выбора даты доставки', 'delivery-times-wc' ),
				'desc' => esc_attr__( 'Отметьте, чтобы обязательно требовать от клиентов выбора даты доставки при оформлении заказа', 'delivery-times-wc' ),
			)
		);

		// Поле: Разделитель.
		$dtwc_obj->add_field(
			'dtwc_basic',
			array(
				'id'   => 'separator_2',
				'type' => 'separator',
			)
		);

		// Поле: Метка для времени доставки.
		$dtwc_obj->add_field(
			'dtwc_basic',
			array(
				'id'      => 'delivery_time_label',
				'type'    => 'text',
				'name'    => esc_attr__( 'Метка для времени доставки', 'delivery-times-wc' ),
				'desc'    => esc_attr__( 'Метка, отображаемая на странице оформления заказа и в деталях заказа', 'delivery-times-wc' ),
				'default' => esc_attr__( 'Время доставки', 'delivery-times-wc' ),
			)
		);

		// Поле: Обязательность выбора времени доставки.
		$dtwc_obj->add_field(
			'dtwc_basic',
			array(
				'id'   => 'require_delivery_time',
				'type' => 'checkbox',
				'name' => esc_attr__( 'Обязательность выбора времени доставки', 'delivery-times-wc' ),
				'desc' => esc_attr__( 'Отметьте, чтобы обязательно требовать от клиентов выбора времени доставки при оформлении заказа', 'delivery-times-wc' ),
			)
		);

		// Поле: Разделитель.
		$dtwc_obj->add_field(
			'dtwc_basic',
			array(
				'id'   => 'separator_1',
				'type' => 'separator',
			)
		);

		// Поле: Дни для предзаказа.
		$dtwc_obj->add_field(
			'dtwc_basic',
			array(
				'id'                => 'preorder_days',
				'type'              => 'number',
				'name'              => esc_attr__( 'Дни для предзаказа', 'delivery-times-wc' ),
				'desc'              => esc_attr__( 'Сколько дней заранее клиенты могут делать заказ? (оставьте пустым для безлимитных заказов)', 'delivery-times-wc' ),
				'default'           => '',
				'sanitize_callback' => 'intval',
			)
		);

		// Поле: Дни для подготовки доставки.
		$dtwc_obj->add_field(
			'dtwc_basic',
			array(
				'id'                => 'prep_days',
				'type'              => 'number',
				'name'              => esc_attr__( 'Дни на подготовку доставки', 'delivery-times-wc' ),
				'desc'              => esc_attr__( 'Сколько дней заранее необходимо для подготовки доставки? (оставьте пустым для доставки в тот же день)', 'delivery-times-wc' ),
				'default'           => '',
				'sanitize_callback' => 'intval',
			)
		);

		// Поле: Время подготовки доставки.
		$dtwc_obj->add_field(
			'dtwc_basic',
			array(
				'id'                => 'prep_time',
				'type'              => 'number',
				'name'              => esc_attr__( 'Время на подготовку доставки', 'delivery-times-wc' ),
				'desc'              => esc_attr__( 'Сколько минут необходимо для подготовки доставки? (полезно для доставки в тот же день)', 'delivery-times-wc' ),
				'default'           => '',
				'sanitize_callback' => 'intval',
			)
		);

		// Массив: Дни доставки.
		$delivery_days = array(
			'sunday'    => esc_attr__( 'Воскресенье', 'delivery-times-wc' ),
			'monday'    => esc_attr__( 'Понедельник', 'delivery-times-wc' ),
			'tuesday'   => esc_attr__( 'Вторник', 'delivery-times-wc' ),
			'wednesday' => esc_attr__( 'Среда', 'delivery-times-wc' ),
			'thursday'  => esc_attr__( 'Четверг', 'delivery-times-wc' ),
			'friday'    => esc_attr__( 'Пятница', 'delivery-times-wc' ),
			'saturday'  => esc_attr__( 'Суббота', 'delivery-times-wc' ),
		);

		// Фильтр для дней доставки.
		$delivery_days = apply_filters( 'dtwc_settings_delivery_days_options', $delivery_days );

		// Поле: Множественный выбор для дней доставки.
		$dtwc_obj->add_field(
			'dtwc_business',
			array(
				'id'      => 'delivery_days',
				'type'    => 'multicheck',
				'name'    => esc_attr__( 'Дни доставки', 'delivery-times-wc' ),
				'desc'    => esc_attr__( 'Выберите дни недели, когда ваш бизнес открыт для доставки', 'delivery-times-wc' ),
				'options' => $delivery_days,
			)
		);

		// Поле: Время открытия.
		$dtwc_obj->add_field(
			'dtwc_business',
			array(
				'id'   => 'opening_time',
				'type' => 'time',
				'name' => esc_attr__( 'Время открытия', 'delivery-times-wc' ),
				'desc' => esc_attr__( 'Во сколько начинается доставка ваших заказов?', 'delivery-times-wc' ),
			)
		);

		// Поле: Время закрытия.
		$dtwc_obj->add_field(
			'dtwc_business',
			array(
				'id'   => 'closing_time',
				'type' => 'time',
				'name' => esc_attr__( 'Время закрытия', 'delivery-times-wc' ),
				'desc' => esc_attr__( 'Во сколько заканчивается доставка ваших заказов?', 'delivery-times-wc' ),
			)
		);

		// Поле: Место отображения времени доставки в админке.
		$dtwc_obj->add_field(
			'dtwc_advanced',
			array(
				'id'      => 'delivery_time_edit_order_display',
				'type'    => 'select',
				'name'    => esc_attr__( 'Место отображения времени доставки в админке', 'delivery-times-wc' ),
				'desc'    => esc_attr__( 'Выберите место отображения времени доставки на экране редактирования заказа', 'delivery-times-wc' ),
				'options' => array(
					'billing'  => esc_attr__( 'После адреса плательщика', 'delivery-times-wc' ),
					'shipping' => esc_attr__( 'После адреса доставки', 'delivery-times-wc' )
				),
				'default' => 'shipping',
			)
		);
		// Поле: Место отображения времени доставки на странице оформления заказа.
		$dtwc_obj->add_field(
			'dtwc_advanced',
			array(
				'id'      => 'delivery_time_checkout_display',
				'type'    => 'select',
				'name'    => esc_attr__( 'Место отображения времени доставки на странице оформления заказа', 'delivery-times-wc' ),
				'desc'    => esc_attr__( 'Выберите место отображения времени доставки на странице оформления заказа', 'delivery-times-wc' ),
				'options' => array(
					'after_billing'  => esc_attr__( 'После адреса плательщика', 'delivery-times-wc' ),
					'after_shipping' => esc_attr__( 'После адреса доставки', 'delivery-times-wc' ),
					'after_notes'    => esc_attr__( 'После примечаний к заказу', 'delivery-times-wc' )
				),
				'default' => 'after_billing',
			)
		);
		// Поле: Удаление времени доставки из писем.
		$dtwc_obj->add_field(
			'dtwc_advanced',
			array(
				'id'   => 'remove_delivery_time_from_emails',
				'type' => 'checkbox',
				'name' => esc_attr__( 'Удалить время доставки из писем клиентам', 'delivery-times-wc' ),
				'desc' => esc_attr__( 'Отметьте, чтобы удалить дату и время доставки из писем', 'delivery-times-wc' ),
			)
		);
	}
	add_action( 'init', 'dtwc_load_admin_settings' );
}