<?php
/**
 * Plugin Name: Плагин уведомления Cookies
 * Description: Простой плагин для уведомления о cookies.
 * Version: 1.6
 * Author: revtail.ru
 * Author URI: https://revtail.ru/
 */

if (!defined('ABSPATH')) {
    exit; // Защита от прямого доступа
}

if (!function_exists('custom_plugin_update_info_wtn')) {
	function custom_plugin_update_info_wtn($transient) {
		if (empty($transient->checked)) {
			return $transient;
		}

		// Уникальный slug плагина
		$plugin_slug = 'cookie-plugin';

		// Запрос к серверу обновлений
		$response = wp_remote_get("https://revtail.ru/wordpress-update-plugins/update-server.php?plugin=$plugin_slug");

		if (is_wp_error($response)) {
			return $transient;
		}

		$data = json_decode(wp_remote_retrieve_body($response));
		if (!$data || isset($data->error)) {
			return $transient;
		}

		// Текущая версия
		$current_version = '1.6';

		// Добавляем обновление, если оно доступно
		if (version_compare($current_version, $data->new_version, '<')) {
			$transient->response = array_merge($transient->response ?? [], [
				"$plugin_slug/$plugin_slug.php" => (object) [
					'slug'        => $plugin_slug,
					'new_version' => $data->new_version,
					'package'     => $data->package,
					'url'         => $data->url,
				]
			]);
		}

		return $transient;
	}
}

// Подключаем к системе обновлений WordPress
add_filter('site_transient_update_plugins', 'custom_plugin_update_info_wtn', 10, 1);

if (!function_exists('custom_plugin_update_details')) {
	function custom_plugin_update_details($false, $action, $args) {
		if ($action !== 'plugin_information' || $args->slug !== 'cookie-plugin') {
			return $false;
		}

		$response = wp_remote_get("https://revtail.ru/wordpress-update-plugins/update-server.php?plugin=$plugin_slug");
		
		if (is_wp_error($response)) {
			return $false;
		}

		$data = json_decode(wp_remote_retrieve_body($response));

		if (!$data) {
			return $false;
		}

		return (object) [
			'name'           => 'Плагин уведомления Cookies',
			'slug'           => 'cookie-plugin',
			'version'        => $data->new_version,
			'author'         => 'revtail.ru',
			'homepage'       => 'https://revtail.ru/',
			'download_link'  => $data->package,
			'sections'       => [
				'description'  => 'Описание вашего плагина.',
				'changelog'    => 'Список изменений в новой версии.',
			],
		];
	}
}

// Добавляем хук для вывода информации об обновлении
add_filter('plugins_api', 'custom_plugin_update_details', 10, 3);

// Подключаем стили и скрипты, если уведомление включено
function cnp_enqueue_scripts() {
    $options = get_option('cnp_settings');
    
    // Если уведомления отключены, не загружаем стили и скрипты
    if (!isset($options['enabled']) || $options['enabled'] !== '1') {
        return;
    }

    wp_enqueue_style('cnp-style', plugin_dir_url(__FILE__) . 'style.css');
    wp_enqueue_script('cnp-script', plugin_dir_url(__FILE__) . 'script.js', array('jquery'), false, true);

    // Передаем настройки в JavaScript
	wp_localize_script('cnp-script', 'cnpVars', array(
		'message' => wp_kses_post($options['message']),
		'bgColor' => $options['bg_color'] ?? '#333',
		// 'buttonColor' => $options['button_color'] ?? '#fff',
        'buttonColorHover' => $options['button_hover_color'] ?? '#555',
        'fontSizeText' => $options['font_size_text'] ?? '16px',
        'fontSizeButton' => $options['font_size_button'] ?? '14px',
        // 'fontFamilyText' => $options['font_family_text'] ?? 'Arial, sans-serif',
        // 'fontFamilyButton' => $options['font_family_button'] ?? 'Arial, sans-serif',
        'boxWidth' => $options['box_width'] ?? '100%',
	));
}
add_action('wp_enqueue_scripts', 'cnp_enqueue_scripts');

function my_cookie_notice_styles() {
    // Получаем шрифт из настроек темы
    ?>
    <style>
        .cookies-box-rv__descr {
            font-family: inherit;
        }
		.cookies-box-rv__btn {
            font-family: inherit;
        }
    </style>
    <?php
}
add_action('wp_head', 'my_cookie_notice_styles');

// Вывод уведомления с учетом введенного HTML
function cnp_cookie_notice() {
    $options = get_option('cnp_settings');

    if (!isset($options['enabled']) || $options['enabled'] !== '1') {
        return;
    }

    ?>
    <!--<div id="cookiesbox" class="cookies-box-rv" style="background-color: <?php echo esc_attr($options['bg_color'] ?? '#333'); ?>; width: <?php echo esc_attr($options['box_width'] ?? '100%'); ?>;">
        <div class="cookies-box-rv__icon cookie-icon"></div>
        <div class="cookies-box-rv__descr" style="font-family: <?php //echo esc_attr($options['font_family_text'] ?? 'Arial, sans-serif'); ?>; font-size: <?php //echo esc_attr($options['font_size_text'] ?? '16px'); ?>;"><?php //echo wp_kses_post($options['message']); ?></div>
        <button id="cookiesok" class="cookies-box-rv__btn" style="font-family: <?php //echo esc_attr($options['font_family_button'] ?? 'Arial, sans-serif'); ?>; font-size: <?php //echo esc_attr($options['font_size_button'] ?? '14px'); ?>; background-color: <?php //echo esc_attr($options['button_color'] ?? '#fff'); ?>;"><?php //echo esc_html__('Все понятно', 'gpress'); ?></button>
    </div>-->
	<style>
	.cookies-box-rv__btn:hover {
		background-color: <?php echo esc_attr($options['button_color'] ?? '#452b1f'); ?>;
	}
	</style>
	<div id="cookiesbox" class="cookies-box-rv" style="background-color: <?php echo esc_attr($options['bg_color'] ?? '#37435d'); ?>; max-width: <?php echo esc_attr($options['box_width'] ?? '490px'); ?>;">
        <div class="cookies-box-rv__icon cookie-icon"></div>
        <div class="cookies-box-rv__descr" style="font-size: <?php echo esc_attr($options['font_size_text'] ?? '12px'); ?>;"><?php echo wp_kses_post($options['message']); ?></div>
        <button id="cookiesok" class="cookies-box-rv__btn" style="font-size: <?php echo esc_attr($options['font_size_button'] ?? '14px'); ?>;"><?php echo esc_html__('Все понятно', 'gpress'); ?></button>
    </div>
    <?php
}
add_action('wp_footer', 'cnp_cookie_notice');

// ----------- АДМИН-ПАНЕЛЬ -------------

// Добавляем пункт "Cookies" в меню админки
function cnp_add_admin_menu() {
    add_menu_page(
        'Cookie Notice',          
        'Cookies',                
        'manage_options',         
        'cnp-settings',           
        'cnp_settings_page',      
        'dashicons-shield-alt',   
        80                        
    );
}
add_action('admin_menu', 'cnp_add_admin_menu');

// Функция для отображения страницы настроек
function cnp_settings_page() {
    ?>
    <div class="wrap">
        <h1>Настройки Cookie</h1>
        <form method="post" action="options.php">
            <?php
            settings_fields('cnp_settings_group');
            do_settings_sections('cnp-settings');
            submit_button();
            ?>
        </form>
    </div>
    <?php
}

// Регистрация настроек
function cnp_register_settings() {
    register_setting('cnp_settings_group', 'cnp_settings');
    add_settings_section('cnp_main_section', 'Основные настройки', null, 'cnp-settings');

    add_settings_field('cnp_enabled', 'Включить уведомление?', 'cnp_enabled_field', 'cnp-settings', 'cnp_main_section');
    add_settings_field('cnp_message', 'Текст уведомления', 'cnp_message_field', 'cnp-settings', 'cnp_main_section');
    add_settings_field('cnp_bg_color', 'Цвет фона', 'cnp_bg_color_field', 'cnp-settings', 'cnp_main_section');
    // add_settings_field('cnp_button_color', 'Цвет кнопки', 'cnp_button_color_field', 'cnp-settings', 'cnp_main_section');
    add_settings_field('cnp_button_hover_color', 'Цвет кнопки при наведении', 'cnp_button_hover_color_field', 'cnp-settings', 'cnp_main_section');
    add_settings_field('cnp_font_size_text', 'Размер шрифта текста', 'cnp_font_size_text_field', 'cnp-settings', 'cnp_main_section');
    add_settings_field('cnp_font_size_button', 'Размер шрифта кнопки', 'cnp_font_size_button_field', 'cnp-settings', 'cnp_main_section');
    // add_settings_field('cnp_font_family_text', 'Шрифт текста', 'cnp_font_family_text_field', 'cnp-settings', 'cnp_main_section');
    // add_settings_field('cnp_font_family_button', 'Шрифт кнопки', 'cnp_font_family_button_field', 'cnp-settings', 'cnp_main_section');
    add_settings_field('cnp_box_width', 'Ширина блока', 'cnp_box_width_field', 'cnp-settings', 'cnp_main_section');
}
add_action('admin_init', 'cnp_register_settings');

// Поле "Включить уведомление?"
function cnp_enabled_field() {
    $options = get_option('cnp_settings');
    $checked = isset($options['enabled']) && $options['enabled'] === '1' ? 'checked' : '';
    echo '<input type="checkbox" name="cnp_settings[enabled]" value="1" ' . $checked . '> Включить уведомление';
}

// Поле "Текст уведомления" с HTML-редактором
function cnp_message_field() {
    $options = get_option('cnp_settings');
    $message = isset($options['message']) ? $options['message'] : 'Мы используем файлы cookie для анализа событий на нашем сайте. Продолжая просмотр сайта, вы принимаете <a href="/privacy-policy/">политику конфиденциальности</a>';
    wp_editor($message, 'cnp_message', array(
        'textarea_name' => 'cnp_settings[message]',
        'textarea_rows' => 10,
        'editor_class' => 'cnp-editor-class',
        'editor_height' => 200,
    ));
}

// Поля для дополнительных настроек
function cnp_bg_color_field() {
    $options = get_option('cnp_settings');
    echo '<input type="color" name="cnp_settings[bg_color]" value="' . esc_attr($options['bg_color'] ?? '#37435d') . '">';
}

/*function cnp_button_color_field() {
    $options = get_option('cnp_settings');
    echo '<input type="color" name="cnp_settings[button_color]" value="' . esc_attr($options['button_color'] ?? '#fff') . '">';
}*/

function cnp_button_hover_color_field() {
    $options = get_option('cnp_settings');
    echo '<input type="color" name="cnp_settings[button_hover_color]" value="' . esc_attr($options['button_hover_color'] ?? '#37435d') . '">';
}

function cnp_font_size_text_field() {
    $options = get_option('cnp_settings');
    echo '<input type="text" name="cnp_settings[font_size_text]" value="' . esc_attr($options['font_size_text'] ?? '12px') . '">';
}

function cnp_font_size_button_field() {
    $options = get_option('cnp_settings');
    echo '<input type="text" name="cnp_settings[font_size_button]" value="' . esc_attr($options['font_size_button'] ?? '14px') . '">';
}

/*function cnp_font_family_text_field() {
    $options = get_option('cnp_settings');
    echo '<input type="text" name="cnp_settings[font_family_text]" value="' . esc_attr($options['font_family_text'] ?? 'Arial, sans-serif') . '">';
}

function cnp_font_family_button_field() {
    $options = get_option('cnp_settings');
    echo '<input type="text" name="cnp_settings[font_family_button]" value="' . esc_attr($options['font_family_button'] ?? 'Arial, sans-serif') . '">';
}*/

function cnp_box_width_field() {
    $options = get_option('cnp_settings');
    echo '<input type="text" name="cnp_settings[box_width]" value="' . esc_attr($options['box_width'] ?? '490px') . '">';
}