<?php
/*
* Plugin Name: Contact Form 7 + Telegram
* Description: Рассылки уведомления от CF7 в группу Telegram (поддержка устаревшей версии PHP)
* Author: revtail.ru
* Author URI: https://revtail.ru/
* Version: 1.1
*/

if (!function_exists('custom_plugin_update_info_wtn')) {
	function custom_plugin_update_info_wtn($transient) {
		if (empty($transient->checked)) {
			return $transient;
		}

		// Уникальный slug плагина
		$plugin_slug = 'cf7-tg';

		// Запрос к серверу обновлений
		$response = wp_remote_get("https://revtail.ru/wordpress-update-plugins/update-server.php?plugin=$plugin_slug");

		if (is_wp_error($response)) {
			return $transient;
		}

		$data = json_decode(wp_remote_retrieve_body($response));
		if (!$data || isset($data->error)) {
			return $transient;
		}

		// Текущая версия
		$current_version = '1.1';

		// Добавляем обновление, если оно доступно
		if (version_compare($current_version, $data->new_version, '<')) {
			$transient->response = array_merge($transient->response ?? [], [
				"$plugin_slug/$plugin_slug.php" => (object) [
					'slug'        => $plugin_slug,
					'new_version' => $data->new_version,
					'package'     => $data->package,
					'url'         => $data->url,
				]
			]);
		}

		return $transient;
	}
}

// Подключаем к системе обновлений WordPress
add_filter('site_transient_update_plugins', 'custom_plugin_update_info_wtn', 10, 1);

if (!function_exists('custom_plugin_update_details')) {
	function custom_plugin_update_details($false, $action, $args) {
		if ($action !== 'plugin_information' || $args->slug !== 'cf7-tg') {
			return $false;
		}

		$response = wp_remote_get("https://revtail.ru/wordpress-update-plugins/update-server.php?plugin=$plugin_slug");
		
		if (is_wp_error($response)) {
			return $false;
		}

		$data = json_decode(wp_remote_retrieve_body($response));

		if (!$data) {
			return $false;
		}

		return (object) [
			'name'           => 'Contact Form 7 + Telegram',
			'slug'           => 'cf7-tg',
			'version'        => $data->new_version,
			'author'         => 'revtail.ru',
			'homepage'       => 'https://revtail.ru/',
			'download_link'  => $data->package,
			'sections'       => [
				'description'  => 'Описание вашего плагина.',
				'changelog'    => 'Список изменений в новой версии.',
			],
		];
	}
}

// Добавляем хук для вывода информации об обновлении
add_filter('plugins_api', 'custom_plugin_update_details', 10, 3);

define( 'WPCF7TG_PLUGIN_NAME', plugin_basename( __FILE__ ) );

define( 'WPCF7TG_VERSION', '' );
define( 'WPCF7TG_FILE', __FILE__ );

const WPCF7TG_MIGRATION_HOOK = 'cf7tg_migrations';

require ( __DIR__ . '/classes/wpcf7telegram.php' );
wpcf7_Telegram::get_instance();

add_action( 'in_plugin_update_message-' . WPCF7TG_PLUGIN_NAME, 'wpcf7tg_plugin_update_message', 10, 2 );

function wpcf7tg_plugin_update_message( $data, $response ) {
	if (
		version_compare( WPCF7TG_VERSION, '0.9', '>=' ) &&
		version_compare( $response->new_version, '1.0', '<' )
	) {
		// Temporary hide the message for users who have already updated to 0.9,
		// but still there's no v1.0 version available.
		return;
	}

	if(
		isset( $data['upgrade_notice'] )
	) :
		printf(
			'<div class="update-message">%s</div>',
			wpautop( $data['upgrade_notice'] )
		);
	endif;
}

add_action(
	'upgrader_process_complete',
	function ( $upgrader, array $hook_extra ) {

		if ( 'update' !== $hook_extra['action'] || 'plugin' !== $hook_extra['type'] ) {
			return;
		}

		if (
			empty( $hook_extra['plugins'] ) ||
			! is_array( $hook_extra['plugins'] ) ||
			! in_array( WPCF7TG_PLUGIN_NAME, $hook_extra['plugins'] )
		) {
			return;
		}

		wp_schedule_single_event(
			time() + 5,
			WPCF7TG_MIGRATION_HOOK,
			[
				'upgrader' => $upgrader,
				'prev-version' => WPCF7TG_VERSION,
			]
		);
	},
	10, 2
);

